//: [Vorherige Seite](@previous)
import UIKit
import PlaygroundSupport
//: ## Animation mit UIViewPropertyAnimator
//: ## – Eigene Beschleunigungskurven
//:
//Demo-View erstellen, Button verschieben und Live-View
let container = demoView(frame: CGRect(x: 0, y: 0,
                                       width: 400, height: 600))
let frame = container.frame
container.demoButton.center = CGPoint(x:frame.midX,
                                      y: frame.midY)
PlaygroundPage.current.liveView = container
//: Wer mit den vorhandenen Beschleunigungskurven nicht zufrieden ist, darf eigene definieren. Zur Beschreibung der Kurve dient ein Objekt, das das UITimingCurveProvider-Protokoll implementiert. Einfych und eindrucksvoll  funktioniert das mit der Klasse UISpringTimingParameters. Diese Klasse berechnet den zeitlichen Verlauf anhand einer Feder-Gleichung. Das macht das Verständnis der Auswirkungen der Parameter etwas schwieriger. Gleichzeitig ist die Timing-Funktion aber besonders interessant, weil der Effekt so natürlich wirkt: Das Objekt bewegt sich nicht einfach nur zur Endposition und stoppt sondern es schießt zunächst etwas über das Ziel hinaus, federt zurück und pendelt sich nach und nach auf der Zielposition ein.

//: Man kann entweder ein eigenes Objekt vom Typ UISpringTimingParameters erzeugen und parametrieren, einfacher geht es aber, den Animator schon bei der Initialisierung mit den nötigen Werten zu versorgen.
public class actionHandler: NSObject {
    public func animate() {
        let animator = UIViewPropertyAnimator(duration: 2.0, dampingRatio: 0.2) { 
            container.demoButton.center.x = frame.maxX - container.demoButton.frame.size.width - 80
        }
        
        animator.addCompletion( { (position) in
            container.demoButton.setTitle("finished", for: .normal)
        })
        
        animator.startAnimation()
    }
}
//: Anschließend können Sie die Action wie gewohnt an den Button anhängen
let responder = actionHandler()
container.demoButton.addTarget(responder, action: #selector(actionHandler.animate), for: .touchDown)
//: [Nächste Seite](@next)
